package gov.va.med.mhv.admin.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="EMPLOYEE")
public class Employee implements Serializable{

	private static final long serialVersionUID = -1865602310865397317L;
	
	
	@Id
	@Column(name="EMPLOYEE_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="USER_NAME")
	private String userName;
		
	@Column(name="FIRST_NAME")
	private String firstName;
	
	@Column(name="LAST_NAME")
	private String lastName;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="LAST_LOGIN_DT")
	private Date lastLoginDate;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="CURRENT_LOGIN_DT")
	private Date currentLoginDate;
	
	@OneToMany(mappedBy="employee",fetch=FetchType.EAGER)
	@Fetch(FetchMode.SELECT)
	private List<EmployeeOrgRole> employeeOrgRoles = new ArrayList<EmployeeOrgRole>();

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Date getLastLoginDate() {
		return lastLoginDate;
	}

	public void setLastLoginDate(Date lastLoginDate) {
		this.lastLoginDate = lastLoginDate;
	}

	public Date getCurrentLoginDate() {
		return currentLoginDate;
	}

	public void setCurrentLoginDate(Date currentLoginDate) {
		this.currentLoginDate = currentLoginDate;
	}

	public List<EmployeeOrgRole> getEmployeeOrgRoles() {
		return employeeOrgRoles;
	}

	public void setEmployeeOrgRoles(List<EmployeeOrgRole> employeeOrgRoles) {
		this.employeeOrgRoles = employeeOrgRoles;
	}
	
	
	
	
	

}
